/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.security.item;

import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.security.ISecurityObject;
import mekanism.api.security.SecurityMode;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.capabilities.resolver.ICapabilityResolver;
import mekanism.common.capabilities.security.item.ItemStackOwnerObject;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.item.ItemStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ItemStackSecurityObject
extends ItemStackOwnerObject
implements ISecurityObject {
    @Override
    @Nonnull
    public SecurityMode getSecurityMode() {
        ItemStack stack = this.getStack();
        return stack.m_41619_() ? SecurityMode.PUBLIC : SecurityMode.byIndexStatic(ItemDataUtils.getInt(stack, "securityMode"));
    }

    @Override
    public void setSecurityMode(SecurityMode mode) {
        SecurityMode current;
        ItemStack stack = this.getStack();
        if (!stack.m_41619_() && (current = this.getSecurityMode()) != mode) {
            ItemDataUtils.setInt(stack, "securityMode", mode.ordinal());
            this.onSecurityChanged(current, mode);
        }
    }

    @Override
    public void onSecurityChanged(@Nonnull SecurityMode old, @Nonnull SecurityMode mode) {
    }

    @Override
    protected void gatherCapabilityResolvers(Consumer<ICapabilityResolver> consumer) {
        consumer.accept(BasicCapabilityResolver.security(this));
    }
}

